<?php

/**
 * The Admin Toold Controller Class
 *
 * @author Yaidier Perez
 * */

namespace Jptgb\Controllers;

class CompabilityController extends BaseController {

    public static $is_elementor_pro_frontend_tag  = '';
    public static $is_elementor_e_sticky_tag      = '';

    public static function init() {
        self::elementor_plugin();
    }

    /**
     * Registers a filter to modify the execution order of scripts for Elementor.
     */
    public static function elementor_plugin() {
        add_filter('jptgb_scripts_loader_list', [self::class, 'modify_execution_order']);
    }

    /**
     * Modifies the execution order of Elementor scripts in the loader list.
     *
     * @param array $scripts_loader_list List of script loaders.
     * @return array Updated list of script loaders.
     */
    public static function modify_execution_order(array $scripts_loader_list) {
        /** 
         * Define keywords for script identification.
         */
        $keywords = [   'elementor/assets/js/webpack.runtime', 
                        'elementor/assets/js/frontend-modules',
                        'elementor-pro/assets/js/webpack-pro.runtime',
                        'elementor-pro/assets/js/elements-handlers',
                        'elementor,elements-handlers',
                        'sticky', 
                        'carousel', 
                        'swiper'
                    ];

        $move_before_jquery_indexs  = [];
        $jquery_core_index          = -1; // Set to -1 to indicate not found initially.

        foreach ($scripts_loader_list as $index => $script_loader_item) {
            if ('script' !== $script_loader_item['type']) {
                continue;
            }

            $src = $script_loader_item['attributes']['src'] ?? false;
            if (!$src) {
                continue;
            }

            $handle = $script_loader_item['handle'] ?? '';
            if (strpos($handle, 'jquery-core') !== false || strpos($handle, 'jquery-migrate') !== false) {
                $jquery_core_index = $index;
            }

            foreach ($keywords as $keyword) {
                $words = explode(',', str_replace(' ', '', $keyword)); // Clean and split the keyword
                $found = true;

                foreach ($words as $word) {
                    if (strpos($src, $word) === false) {
                        $found = false;
                        break;
                    }
                }

                if ($found) {
                    $move_before_jquery_indexs[$index] = $keyword;
                    break;
                }
            }
        }

        // Sort indices to move by the order of keywords
        uksort($move_before_jquery_indexs, function($a, $b) use ($move_before_jquery_indexs, $keywords) {
            $keywordA = array_search($move_before_jquery_indexs[$a], $keywords);
            $keywordB = array_search($move_before_jquery_indexs[$b], $keywords);
            return $keywordA <=> $keywordB;
        });

        if (!empty($move_before_jquery_indexs)) {
            if ($jquery_core_index == -1) {
                // If jQuery is not found, set the target index to 0, moving matched scripts to the beginning.
                foreach (array_keys($move_before_jquery_indexs) as $move_before_jquery_index) {
                    self::moveElement($scripts_loader_list, $move_before_jquery_index, 0);
                }
            } else {
                // Move scripts to the position after jQuery if found, in the order they appear in $keywords.
                $targetIndex = $jquery_core_index + 1;
                foreach (array_keys($move_before_jquery_indexs) as $move_before_jquery_index) {
                    self::moveElement($scripts_loader_list, $move_before_jquery_index, $targetIndex++);
                }
            }
        }

        return $scripts_loader_list;
    }
    /**
     * Moves an element within an array from one index to another.
     *
     * This function modifies the array by moving an element from a specified source
     * index to a position immediately after the specified destination index.
     *
     * @param array &$array Array to be modified.
     * @param int $fromIndex Source index.
     * @param int $toIndex Destination index.
     */
    public static function moveElement(array &$array, int $fromIndex, int $toIndex) {
        if ($fromIndex === $toIndex || $fromIndex < 0 || $toIndex < 0 || $fromIndex >= count($array) || $toIndex >= count($array)) {
            return;
        }

        $item = array_splice($array, $fromIndex, 1)[0];

        // Adjust the toIndex if the item is being moved forward.
        if ($fromIndex < $toIndex) {
            $toIndex--;
        }

        array_splice($array, $toIndex, 0, [$item]);
    }
}