<?php

/**
 * The Scripts Controller Class.
 *
 * @author Yaidier Perez
 * */

namespace Jptgb\Controllers;

use Jptgb\Resources\Utils;

class FontsController extends BaseController {

    public static function init() {
        /**
         * If we just turn on/off the fonts controller,
         * and the cache was active then lets
         * clear up the cache then.
         */
        if( in_array( 'jptgb_setting_load_fonts_on_fui', self::$changed_settings ) ||
            in_array( 'jptgb_setting_load_fa_icons_on_fui', self::$changed_settings ) ) {
            // CacheController::flush_all_cache_files();
        }

        /**
         * Return if Load Fonts on FUI is deactivated.
         * 
         * @see Wp Dashboard -> Jptgb -> Fonts
         */
        // if( !isset( self::$settings['jptgb_setting_load_fonts_on_fui'] ) || !self::$settings['jptgb_setting_load_fonts_on_fui'] ) {
        //     return;
        // }

        /**
         * Init scripts handler.
         */
        add_action( 'wp', [self::class, 'init_fonts_handler'] );
    }

    public static function init_fonts_handler() {
        // /**
        //  * Do not apply Optimizations for the backend or logged-in users.
        //  */
		// if ( is_admin() || is_user_logged_in() ) {
        //     return;
		// }

        // /** 
        //  * Return if we are on login page.
        //  */
        // if( $GLOBALS['pagenow'] == 'ps-access.php' ){
        //     return;
        // }

        /**
         * Generate critical css.
         */
        // add_action( 'wp_footer', [self::class, 'load_fonts_on_fui'], PHP_INT_MAX - 8 );


        /**
         * Do not apply Optimizations for the backend or logged-in users.
         */
        if( is_admin() || is_user_logged_in() ) {
            return;
        }

        /*
        * If this is an autosave, our form has not been submitted,
        * so we don't want to do anything.
        */
        if ( ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) || ( defined( 'DOING_AJAX' ) && DOING_AJAX ) || isset( $_REQUEST['bulk_edit'] ) ) {
            return;
        } 

        
    }

    

    public static function load_fonts_on_fui() {
        ?>
            <script id="jptgb-controller-fonts" class="jptgb-script">
                /**
                 * Command the cache controller to load fonts on FUI.
                 */
                document.jptgbLoadFontsOnFui = '1';
            </script>
        <?php
    }

    public static function modify_page_contents( $cache_file_contents ) {
        /**
         * Extract fonts data from the html document.
         */
        $fonts_data = self::extract_scripts( $cache_file_contents );

        

        return $cache_file_contents;
    }

    public static function extract_scripts($html) {
        $scripts = [];
        $start = 0;
    
        while (($start = strpos($html, '<script', $start)) !== false) {
            $endOfOpeningTag = strpos($html, '>', $start) + 1;
            $scriptTagOpening = substr($html, $start, $endOfOpeningTag - $start);
    
            // Check if the script tag is for an external script (has src attribute)
            if (strpos($scriptTagOpening, 'src=') !== false) {
                // Find the position of the next script tag or the end of the string
                $nextScriptStart = strpos($html, '<script', $endOfOpeningTag);
                $endTagStart = strpos($html, '</script>', $start);
                
                // Determine the end of the current script tag
                if ($endTagStart !== false && ($nextScriptStart === false || $endTagStart < $nextScriptStart)) {
                    $endTagEnd = $endTagStart + strlen('</script>');
                } else {
                    $endTagEnd = $endOfOpeningTag; // Shorthand syntax, no closing tag
                }
    
                // Extract the full script tag
                $scriptTagFull = substr($html, $start, $endTagEnd - $start);
                $start = $endTagEnd;
    
                // Extract attributes
                $attributes = [];
                $pattern = '/(\w+)=[\'"]?([^\'">\s]+)[\'"]?/';
                if (preg_match_all($pattern, $scriptTagOpening, $matches, PREG_SET_ORDER)) {
                    foreach ($matches as $match) {
                        $attributes[$match[1]] = $match[2];
                    }
                }
    
                $attributes['tag'] = $scriptTagFull;
    
                if (!empty($attributes)) {
                    $scripts[] = $attributes;
                }
            } else {
                // Move to the end of this script tag to continue search
                $start = $endOfOpeningTag;
            }
        }
    
        return $scripts;
    }

    /**
     * Get script dependencies with "-js" suffix.
     *
     * @param string $handle The script handle.
     * @return array Returns an array of dependencies with "-js" suffix.
     */
    public static function get_script_dependencies( $handle ) {
        /** Get global scripts variable */
        global $wp_scripts;

        /** Define initial dependencies */
        $dependencies = [];

        /** Check if this script handle is registered in $wp_scripts */
        if ( isset( $wp_scripts->registered[$handle] ) ) {
            /** Get the dependencies for this script */
            $dependencies = $wp_scripts->registered[$handle]->deps;

            /** Add "-js" suffix to each dependency */
            $dependencies = array_map(function($dependency) {
                return $dependency . '-js';
            }, $dependencies);
        }

        return $dependencies;
    }
}