<?php

namespace Jptgb\Controllers;

use Jptgb\Resources\Utils;

/**
 * The Self Hosted Controller Class
 *
 * @author Yaidier Perez
 * */

class SelfHostedController extends BaseController {
    public static function init() {
        
    }

    public static function get_services_status(): array {
        /**
         * Define the services to check.
         */
        $services_to_check = [
            [
                'name'          => 'exec function',
                'check_cmd'     => 'php -v',
                'status'        => 'inactive',
                'success_msg'   => 'The exec() function is executable',
                'output_msg'    => 'The exec() function is either not executable or not present on the server.',
            ],
            [
                'name'          => 'nodejs',
                'check_cmd'     => 'node -v',
                'status'        => 'inactive',
                'success_msg'   => 'Node.js is installed. Version: {{version}}',
                'output_msg'    => 'Node.js is not installed on the server.',
            ],
            [
                'name'          => 'npm',
                'check_cmd'     => 'npm -v',
                'status'        => 'inactive',
                'success_msg'   => 'Npm is installed. Version: {{version}}',
                'output_msg'    => 'Npm is not installed on the server.',
            ],
            [
                'name'          => 'composer',
                'check_cmd'     => 'composer --version',
                'status'        => 'inactive',
                'success_msg'   => 'Composer is installed. Version: {{version}}',
                'output_msg'    => 'Composer is not installed on the server.',
            ],
            [
                'name'          => 'chromium',
                'check_cmd'     => 'chromium --version',
                'status'        => 'inactive',
                'success_msg'   => 'Chromium is installed. Version: {{version}}',
                'output_msg'    => 'Chromium is not installed on the server.',
            ],
        ];

        /**
         * Check if the exec function is available.
         */
        $is_exec_function_available = function_exists( 'exec' );

        /**
         * Check the services which are enabled.
         */
        foreach( $services_to_check as &$service_to_check ){
            if( !$is_exec_function_available ){
                $service_to_check['status'] = 'inactive';
                continue;
            }

            /**
             * Continue if the check cmd is not set.
             */
            if( !isset( $service_to_check[ 'check_cmd' ] ) || !$service_to_check[ 'check_cmd' ] ){
                continue;
            }

            /**
             * Execute the command to check for the service.
             */
            $output     = null;
            $return_var = null;
            \exec( $service_to_check[ 'check_cmd' ], $output, $return_var );

            /**
             * Check if the command was successful.
             */
            if ( $return_var === 0 && !empty( $output ) ) {
                $version                        =  esc_html( $output[0] );
                $service_to_check['status']     = 'active';
                $service_to_check['output_msg'] = str_replace( '{{version}}', $version, $service_to_check['success_msg'] );
            }
        }

        return $services_to_check;
    }
}
