<?php 
namespace Jptgb\Includes;

use Jptgb\Controllers\BaseController;
use Jptgb\Controllers\CacheController;
use Jptgb\Controllers\AjaxController;
use Jptgb\Resources\Utils;

class ColumnPanel extends BaseController {

    public static function render( $post_id ) {        
        /**
         * Get the current cache status.
         */
        $cache_data = Utils::get_cache_data( $post_id );
        $status     = $cache_data['status'];
        $message    = $cache_data['message']    ?? '';
        $percentage = $cache_data['percentage'] ?? 0;

        /** 
         * If the cache status is ready, ensure both mobile & desktop cache files exist.
         */
        if ( 'cache-ready' === $status ) {
            /** @var string $requested_url The permalink for this post. */
            $requested_url = Utils::get_permalink( $post_id );
            /** @var string $request_path The normalized request-path for cache lookup. */
            $request_path = CacheController::get_request_path( $requested_url, true );
            /** @var string $cache_dir Base directory where all caches live. */
            $cache_dir = CacheController::get_cache_dir_path();

            /** @var string[] $missing Devices whose cache files are missing. */
            $missing = array();

            foreach ( array( 'mobile', 'desktop' ) as $device ) {
                /** Build the full directory + filename for this device. */
                $device_dir       = trailingslashit( "{$cache_dir}/{$device}{$request_path}" );
                $cached_file_path = "{$device_dir}index.html";

                /** If the file isn’t there, note it. */
                if ( ! Utils::does_file_exists( $cached_file_path ) ) {
                    $missing[] = $device;
                }
            }

            if ( ! empty( $missing ) ) {
                $status     = 'no-cache';
                $percentage = 0;

                /** @var string $message Craft a clear error for one or both missing. */
                if ( count( $missing ) === 2 ) {
                    $message = __( 'The cache was built, but both mobile and desktop cache files are missing.', 'webspeed' );
                } else {
                    /* translators: %s is “mobile” or “desktop”. */
                    $message = sprintf(
                        /* translators: %s: device type. */
                        __( 'The cache was built, but the %s cache file is missing.', 'webspeed' ),
                        esc_html( $missing[0] )
                    );
                }

                /**
                 * Register the incident.
                 */
                BaseController::$logs->register( $message . ' | Url: ' . $requested_url, 'warning' );

                // One single AJAX call to update status, message, and reset progress.
                AjaxController::update_cache_status( $post_id, $status, $message, $percentage );
            }
        }


        ?>
            <div class="jptgb jptgb-tool_column" data-id="<?php echo esc_attr( $post_id ) ?>" data-type="post" data-cachestatus="<?php echo esc_attr( $status ) ?>">
                <img class="jptgb-tool_column_option jptgb-tool_column_loading_icon" src="<?php echo esc_url( JPTGB_URL . 'assets/svg/loading.svg' ) ?>" alt="loading">
                <div class="jptgb-tool_column_option jptgb-speed_up_btn <?php if( 'no-cache' == $status ) :?>jptgb_active<?php endif ?>">Speed Up</div>
                <div class="jptgb-tool_column_option jptgb-ready <?php if( 'cache-ready' == $status ) :?>jptgb_active<?php endif ?>">
                    <div class="jptgb-ready_banner">Ready</div>
                    <div class="jptgb-ready_options">
                        <div class="jptgb-ready_rebuild">
                            <svg width="12" height="12" viewBox="0 0 12 12" fill="#D1D1D8" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1_65)">
                                    <path d="M10.8633 5.25H11.0625C11.3742 5.25 11.625 4.99922 11.625 4.6875V1.6875C11.625 1.46016 11.489 1.25391 11.2781 1.16719C11.0672 1.08047 10.8258 1.12734 10.664 1.28906L9.68904 2.26406C7.63591 0.236719 4.32888 0.24375 2.28748 2.2875C0.236694 4.33828 0.236694 7.66172 2.28748 9.7125C4.33826 11.7633 7.66169 11.7633 9.71248 9.7125C10.0054 9.41953 10.0054 8.94375 9.71248 8.65078C9.41951 8.35781 8.94373 8.35781 8.65076 8.65078C7.18591 10.1156 4.81169 10.1156 3.34685 8.65078C1.88201 7.18594 1.88201 4.81172 3.34685 3.34688C4.80466 1.88906 7.16013 1.88203 8.62732 3.32344L7.66404 4.28906C7.50232 4.45078 7.45544 4.69219 7.54216 4.90313C7.62888 5.11406 7.83513 5.25 8.06248 5.25H10.8633Z"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_65">
                                        <rect width="12" height="12" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                            <output class="jptgb-tooltip">Rebuild Cache</output>
                        </div>
                        <div class="jptgb-ready_delete">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#D1D1D8" viewBox="0 0 448 512"><!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                <path d="M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16z"/>
                            </svg>
                            <output class="jptgb-tooltip">Delete Cache</output>
                        </div>
                    </div>
                </div>
                <div class="jptgb-tool_column_option jptgb-working <?php if( 'working-on' == $status ) :?>jptgb_active<?php endif ?>">
                    <div class="jptgb-working_info">
                        <div class="jptgb-working_info_status">
                            <svg width="6" height="6" viewBox="0 0 6 6" fill="#2F2F31" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1_27)">
                                    <path d="M5.4375 3C5.4375 2.35353 5.18069 1.73355 4.72357 1.27643C4.26645 0.819307 3.64647 0.5625 3 0.5625C2.35353 0.5625 1.73355 0.819307 1.27643 1.27643C0.819307 1.73355 0.5625 2.35353 0.5625 3C0.5625 3.64647 0.819307 4.26645 1.27643 4.72357C1.73355 5.18069 2.35353 5.4375 3 5.4375C3.64647 5.4375 4.26645 5.18069 4.72357 4.72357C5.18069 4.26645 5.4375 3.64647 5.4375 3ZM0 3C0 2.20435 0.316071 1.44129 0.87868 0.87868C1.44129 0.316071 2.20435 0 3 0C3.79565 0 4.55871 0.316071 5.12132 0.87868C5.68393 1.44129 6 2.20435 6 3C6 3.79565 5.68393 4.55871 5.12132 5.12132C4.55871 5.68393 3.79565 6 3 6C2.20435 6 1.44129 5.68393 0.87868 5.12132C0.316071 4.55871 0 3.79565 0 3ZM1.98984 1.93711C2.08242 1.67578 2.33086 1.5 2.60859 1.5H3.2918C3.70078 1.5 4.03125 1.83164 4.03125 2.23945C4.03125 2.5043 3.88945 2.74922 3.65977 2.88164L3.28125 3.09844C3.27891 3.25078 3.15352 3.375 3 3.375C2.84414 3.375 2.71875 3.24961 2.71875 3.09375V2.93555C2.71875 2.83477 2.77266 2.74219 2.86055 2.6918L3.37969 2.39414C3.43477 2.3625 3.46875 2.30391 3.46875 2.24062C3.46875 2.14219 3.38906 2.06367 3.2918 2.06367H2.60859C2.56875 2.06367 2.53359 2.08828 2.5207 2.12578L2.51602 2.13984C2.46445 2.28633 2.30273 2.3625 2.15742 2.31094C2.01211 2.25937 1.93477 2.09766 1.98633 1.95234L1.99102 1.93828L1.98984 1.93711ZM2.625 4.125C2.625 4.02554 2.66451 3.93016 2.73484 3.85984C2.80516 3.78951 2.90054 3.75 3 3.75C3.09946 3.75 3.19484 3.78951 3.26516 3.85984C3.33549 3.93016 3.375 4.02554 3.375 4.125C3.375 4.22446 3.33549 4.31984 3.26516 4.39016C3.19484 4.46049 3.09946 4.5 3 4.5C2.90054 4.5 2.80516 4.46049 2.73484 4.39016C2.66451 4.31984 2.625 4.22446 2.625 4.125Z"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_27">
                                        <rect width="6" height="6" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                            <output class="jptgb-tooltip" data-value="<?php echo esc_attr( $message ) ?>"><?php echo esc_attr( $message ) ?></output>
                        </div>
                        <output class="jptgb-working_info_percentage" data-value="<?php echo esc_attr( $percentage ) ?>"><?php echo esc_attr( $percentage ) ?>%</output>                       
                    </div>
                    <div class="jptgb-working_status_bar">
                        <div class="jptgb-working_status_bar_fill" style="width:<?php echo esc_attr( $percentage ); ?>%"></div>
                    </div>
                    <div class="jptgb-working_options">
                        <div class="jptgb-ready_rebuild">
                            <svg width="12" height="12" viewBox="0 0 12 12" fill="#D1D1D8" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1_65)">
                                    <path d="M10.8633 5.25H11.0625C11.3742 5.25 11.625 4.99922 11.625 4.6875V1.6875C11.625 1.46016 11.489 1.25391 11.2781 1.16719C11.0672 1.08047 10.8258 1.12734 10.664 1.28906L9.68904 2.26406C7.63591 0.236719 4.32888 0.24375 2.28748 2.2875C0.236694 4.33828 0.236694 7.66172 2.28748 9.7125C4.33826 11.7633 7.66169 11.7633 9.71248 9.7125C10.0054 9.41953 10.0054 8.94375 9.71248 8.65078C9.41951 8.35781 8.94373 8.35781 8.65076 8.65078C7.18591 10.1156 4.81169 10.1156 3.34685 8.65078C1.88201 7.18594 1.88201 4.81172 3.34685 3.34688C4.80466 1.88906 7.16013 1.88203 8.62732 3.32344L7.66404 4.28906C7.50232 4.45078 7.45544 4.69219 7.54216 4.90313C7.62888 5.11406 7.83513 5.25 8.06248 5.25H10.8633Z"/>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_65">
                                        <rect width="12" height="12" fill="white"/>
                                    </clipPath>
                                </defs>
                            </svg>
                            <output class="jptgb-tooltip">Rebuild Cache</output>
                        </div>
                        <div class="jptgb-ready_delete">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#D1D1D8" viewBox="0 0 448 512"><!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                <path d="M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16z"></path>
                            </svg>
                            <output class="jptgb-tooltip">Delete Cache</output>
                        </div>
                    </div>
                </div>
                <div class="jptgb-tool_column_option jptgb-blocked <?php if( 'blocked' == $status || 'error' == $status ) :?>jptgb_active<?php endif ?>">
                    <div class="jptgb-blocked_info">
                        <svg width="6" height="6" viewBox="0 0 6 6" fill="#2F2F31" xmlns="http://www.w3.org/2000/svg">
                            <g clip-path="url(#clip0_1_27)">
                                <path d="M5.4375 3C5.4375 2.35353 5.18069 1.73355 4.72357 1.27643C4.26645 0.819307 3.64647 0.5625 3 0.5625C2.35353 0.5625 1.73355 0.819307 1.27643 1.27643C0.819307 1.73355 0.5625 2.35353 0.5625 3C0.5625 3.64647 0.819307 4.26645 1.27643 4.72357C1.73355 5.18069 2.35353 5.4375 3 5.4375C3.64647 5.4375 4.26645 5.18069 4.72357 4.72357C5.18069 4.26645 5.4375 3.64647 5.4375 3ZM0 3C0 2.20435 0.316071 1.44129 0.87868 0.87868C1.44129 0.316071 2.20435 0 3 0C3.79565 0 4.55871 0.316071 5.12132 0.87868C5.68393 1.44129 6 2.20435 6 3C6 3.79565 5.68393 4.55871 5.12132 5.12132C4.55871 5.68393 3.79565 6 3 6C2.20435 6 1.44129 5.68393 0.87868 5.12132C0.316071 4.55871 0 3.79565 0 3ZM1.98984 1.93711C2.08242 1.67578 2.33086 1.5 2.60859 1.5H3.2918C3.70078 1.5 4.03125 1.83164 4.03125 2.23945C4.03125 2.5043 3.88945 2.74922 3.65977 2.88164L3.28125 3.09844C3.27891 3.25078 3.15352 3.375 3 3.375C2.84414 3.375 2.71875 3.24961 2.71875 3.09375V2.93555C2.71875 2.83477 2.77266 2.74219 2.86055 2.6918L3.37969 2.39414C3.43477 2.3625 3.46875 2.30391 3.46875 2.24062C3.46875 2.14219 3.38906 2.06367 3.2918 2.06367H2.60859C2.56875 2.06367 2.53359 2.08828 2.5207 2.12578L2.51602 2.13984C2.46445 2.28633 2.30273 2.3625 2.15742 2.31094C2.01211 2.25937 1.93477 2.09766 1.98633 1.95234L1.99102 1.93828L1.98984 1.93711ZM2.625 4.125C2.625 4.02554 2.66451 3.93016 2.73484 3.85984C2.80516 3.78951 2.90054 3.75 3 3.75C3.09946 3.75 3.19484 3.78951 3.26516 3.85984C3.33549 3.93016 3.375 4.02554 3.375 4.125C3.375 4.22446 3.33549 4.31984 3.26516 4.39016C3.19484 4.46049 3.09946 4.5 3 4.5C2.90054 4.5 2.80516 4.46049 2.73484 4.39016C2.66451 4.31984 2.625 4.22446 2.625 4.125Z"/>
                            </g>
                            <defs>
                                <clipPath id="clip0_1_27">
                                    <rect width="6" height="6" fill="white"/>
                                </clipPath>
                            </defs>
                        </svg>
                        <output class="jptgb-tooltip" data-value="<?php echo esc_attr( $message ) ?>"><?php echo esc_attr( $message ) ?></output>
                    </div>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.6.0 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M256 32c14.2 0 27.3 7.5 34.5 19.8l216 368c7.3 12.4 7.3 27.7 .2 40.1S486.3 480 472 480L40 480c-14.3 0-27.6-7.7-34.7-20.1s-7-27.8 .2-40.1l216-368C228.7 39.5 241.8 32 256 32zm0 128c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>
                    <div class="jptgb-ready_options">
                        <div class="jptgb-ready_rebuild">
                            <svg width="12" height="12" viewBox="0 0 12 12" fill="#D1D1D8" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_1_65)">
                                    <path d="M10.8633 5.25H11.0625C11.3742 5.25 11.625 4.99922 11.625 4.6875V1.6875C11.625 1.46016 11.489 1.25391 11.2781 1.16719C11.0672 1.08047 10.8258 1.12734 10.664 1.28906L9.68904 2.26406C7.63591 0.236719 4.32888 0.24375 2.28748 2.2875C0.236694 4.33828 0.236694 7.66172 2.28748 9.7125C4.33826 11.7633 7.66169 11.7633 9.71248 9.7125C10.0054 9.41953 10.0054 8.94375 9.71248 8.65078C9.41951 8.35781 8.94373 8.35781 8.65076 8.65078C7.18591 10.1156 4.81169 10.1156 3.34685 8.65078C1.88201 7.18594 1.88201 4.81172 3.34685 3.34688C4.80466 1.88906 7.16013 1.88203 8.62732 3.32344L7.66404 4.28906C7.50232 4.45078 7.45544 4.69219 7.54216 4.90313C7.62888 5.11406 7.83513 5.25 8.06248 5.25H10.8633Z"></path>
                                </g>
                                <defs>
                                    <clipPath id="clip0_1_65">
                                        <rect width="12" height="12" fill="white"></rect>
                                    </clipPath>
                                </defs>
                            </svg>
                            <output class="jptgb-tooltip">Rebuild Cache</output>
                        </div>
                        <div class="jptgb-ready_delete">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="#D1D1D8" viewBox="0 0 448 512"><!--!Font Awesome Free 6.5.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.-->
                                <path d="M135.2 17.7C140.6 6.8 151.7 0 163.8 0H284.2c12.1 0 23.2 6.8 28.6 17.7L320 32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H32C14.3 96 0 81.7 0 64S14.3 32 32 32h96l7.2-14.3zM32 128H416V448c0 35.3-28.7 64-64 64H96c-35.3 0-64-28.7-64-64V128zm96 64c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16V432c0 8.8 7.2 16 16 16s16-7.2 16-16V208c0-8.8-7.2-16-16-16z"></path>
                            </svg>
                            <output class="jptgb-tooltip">Delete Cache</output>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}
