<?php

namespace Jptgb\Includes;

use Jptgb\Controllers\BaseController;
use Jptgb\Resources\Utils;

class Controls extends BaseController {
    public static function get_control_status( $id ) {        
        if( isset( self::$settings[ $id ] ) ){
            return self::$settings[ $id ] ? 'checked' : '';
        }

        return '';
    }

    public static function get_control_value( $id ) {        
        if( isset( self::$settings[ $id ] ) ){
            return self::$settings[ $id ];
        }

        return '';
    }

    public static function render_button( string $id, string $title, string $description = '', string $button_label = '', string $style = 'danger', $type = '' ){
        /**
         * Add prefix to id.
         */
        $setting_id = 'jptgb_setting_' . $id;

        ?>
            <div class="jptgb-button">
                <div class="jptgb-setting_desc_wrap">
                    <div class="jptgb-setting_subtitle"><?php echo wp_kses_post( $title ) ?></div>
                    <div class="jptgb-setting_description"><?php echo wp_kses_post( $description ) ?></div>
                </div>
                <?php if ( 'submit' === $type ): ?>
                    <input id="<?php echo esc_attr( $setting_id ) ?>" class="jptgb-button_btn <?php echo esc_attr( $style ) ?>" type="<?php echo esc_attr( $type ) ?>" name="<?php echo esc_attr( $id ) ?>" value="<?php echo esc_attr( $button_label ) ?>" aria-label="<?php echo esc_attr( $button_label ) ?>">
                <?php else: ?>
                    <div id="<?php echo esc_attr( $setting_id ) ?>" class="jptgb-button_btn <?php echo esc_attr( $style ) ?>" role="button" <?php if( $type ):?>type="<?php echo esc_attr( $type ) ?>"<?php endif ?> aria-label="<?php echo esc_attr( $button_label ) ?>"><?php echo esc_attr( $button_label ) ?></div>
                <?php endif ?>
            </div>
        <?php
    }

    public static function render_input_field( string $id, string $type, string $title = '', string $description = '', array $btn = [], string $status = '', string $placeholder = '', $attr = [] ): void {
        /**
         * Add prefix to id.
         */
        $id = 'jptgb_setting_' . $id;

        /**
         * Get the control value.
         */
        $value = self::get_control_value( $id );

        $html_attrs = '';
        if( !empty( $attr ) ){
            $html_attrs = ' ' . Utils::build_html_attributes( $attr );
        }

        ?>
            <div class="jptgb-input">
                <div class="jptgb-setting_desc_wrap">
                    <div class="jptgb-setting_subtitle"><?php echo wp_kses_post( $title ) ?></div>
                    <div class="jptgb-setting_description"><?php echo wp_kses_post( $description )?></div>
                </div>
                <div class="jptgb-input_controls">
                    <div class="jptgb-input_wrap">
                        <?php if ( 'textarea' == $type ) : ?>
                            <textarea type="<?php echo esc_attr( $type ) ?>" placeholder="<?php echo esc_attr( $placeholder ) ?>" id="<?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $id ) ?>"<?php echo esc_attr( $html_attrs ) ?>><?php echo esc_attr( $value ) ?></textarea>
                        <?php else : ?>
                            <input type="<?php echo esc_attr( $type ) ?>" placeholder="<?php echo esc_attr( $placeholder ) ?>" id="<?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $id ) ?>" value="<?php echo esc_attr( $value ) ?>"<?php echo esc_attr( $html_attrs ) ?>>
                        <?php endif ?>
                        <div class="jptgb-setting_validation"></div>
                        <div class="jptgb-setting_information"></div>
                    </div>
                    <?php if( ! empty( $btn ) ) : 
                        $btn_label  = $btn['label'] ?? '';
                        $btn_id     = isset( $btn['id'] ) ? 'jptgb_setting_' . $btn['id'] : '';
                        ?>

                        <div id="<?php echo esc_attr( $btn_id ) ?>" class="jptgb-input_btn" role="button"><?php echo esc_attr( $btn_label ) ?></div>
                    <?php endif ?>

                    <?php if( $status ) :?>
                        <div class="jptgb-input_status <?php echo esc_attr( 'jptgb__' . $status ) ?>">
                            <svg class="jptgb__icon_checked" xmlns="http://www.w3.org/2000/svg" height="16" width="16" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"/></svg>
                            <svg class="jptgb__icon_warning" xmlns="http://www.w3.org/2000/svg" height="16" width="16" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M256 32c14.2 0 27.3 7.5 34.5 19.8l216 368c7.3 12.4 7.3 27.7 .2 40.1S486.3 480 472 480H40c-14.3 0-27.6-7.7-34.7-20.1s-7-27.8 .2-40.1l216-368C228.7 39.5 241.8 32 256 32zm0 128c-13.3 0-24 10.7-24 24V296c0 13.3 10.7 24 24 24s24-10.7 24-24V184c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>
                            <div class="jptgb-input_status_text"></div>
                        </div>
                    <?php endif ?>
                </div>
            </div>
        <?php
    }

    public static function render_info( string $title = '', string $description = '', string $value = '', string $classes = '' ) : void {
        ?>
            <div class="jptgb-input">
                <div class="jptgb-setting_desc_wrap">
                    <div class="jptgb-setting_subtitle"><?php echo wp_kses_post( $title ) ?></div>
                    <div class="jptgb-setting_description"><?php echo wp_kses_post( $description ) ?></div>
                </div>
                <div class="jptgb-input_controls">
                    <div class="jptgb-input_wrap">
                        <div class="jptgb-input_wrap_info <?php echo esc_attr( $classes ) ?>"><?php echo esc_attr( $value ) ?></div>
                    </div>
                </div>
            </div>
        <?php
    }

    public static function render_switch_btn( string $id, string $title = '', string $description = '' ) : void {
        /**
         * Add prefix to id.
         */
        $id = 'jptgb_setting_' . $id;

        /**
         * Check if current checkbox is active.
         */
        $is_checked = self::get_control_status( $id );

        ?>
            <div class="jptgb-switch">
                <div class="jptgb-setting_desc_wrap">
                    <?php if( $title ) : ?>
                        <div class="jptgb-setting_subtitle"><?php echo wp_kses_post( $title ) ?></div>
                    <?php endif ?>
                    <?php if( $description ) : ?>
                        <div class="jptgb-setting_description"><?php echo wp_kses_post( $description ) ?></div> 
                    <?php endif ?>
                </div>

                <!-- Hidden input to ensure a value is sent when the checkbox is not checked -->
                <input type="hidden" name="<?php echo esc_attr( $id ) ?>" value="button__off">
                <input type="checkbox" id="<?php echo esc_attr( $id ) ?>" name="<?php echo esc_attr( $id ) ?>" value="button__on" class="jptgb-switch_checkbox" <?php echo esc_attr( $is_checked ) ?>>
                <label class="jptgb-switch_label" for="<?php echo esc_attr( $id ) ?>">
                    <span class="jptgb-switch_inner"></span>
                    <span class="jptgb-switch_switch"></span>
                </label>
            </div>
        <?php
    }

    public static function render_checkbox_group( string $id, string $title = '', string $description = '', array $checkboxes_data = [], array $display_conditions = [] ) : void {
        /**
         * Add prefix to id.
         */
        $id = 'jptgb_setting_' . $id;

        /**
         * Get the control value.
         */
        $checked_values = self::get_setting( $id );

        /**
         * Check if it has display conditions.
         */
        $has_display_conditions = count( $display_conditions ) > 0 ? true : false;

        ?>
            <?php if( $has_display_conditions ) : ?>
                <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( $display_conditions ) ) ?>">
            <?php endif ?>

            <div class="jptgb-checkbox_group">
                <div class="jptgb-setting_desc_wrap">
                    <div class="jptgb-setting_subtitle"><?php echo wp_kses_post( $title ); ?></div>
                    <div class="jptgb-setting_description"><?php echo wp_kses_post( $description ); ?></div>
                </div>
                <div class="jptgb-checkbox_group_controls">
                    <!-- Add a hidden input to ensure the field is always sent -->
                    <input type="hidden" name="checkboxes[<?php echo esc_attr( $id ); ?>]" value="">

                    <?php foreach ( $checkboxes_data as $checkbox_data ) : ?>
                        <label>
                            <input type="checkbox" name="checkboxes[<?php echo esc_attr( $id ); ?>][]" value="<?php echo esc_attr( $checkbox_data['value'] ) ?>" <?php if ( in_array( $checkbox_data['value'], $checked_values ) ) : ?>checked<?php endif ?>>
                            <span><?php echo esc_html( $checkbox_data['label'] ) ?></span>
                        </label>
                    <?php endforeach; ?>
                </div>
                <?php  ?>
            </div>

            <?php if( $has_display_conditions ) : ?>
                </div>
            <?php endif ?>
        <?php
    }
}