<?php

namespace Jptgb\Includes;

use Jptgb\Includes\PostListTable;
use Jptgb\Resources\Utils;

class Dashboard {
    /**
     * Render the dashboard page.
     */
    public static function render() {
        /**
         * Get the active tab or default to 'post'.
         */
        $active_tab         = isset( $_GET['tab'] ) ? sanitize_text_field( $_GET['tab'] ) : 'page';

        $cache_data         = Utils::get_posts_cache_data();
        $tasks_overview     = $cache_data['tasks_overview'];
        $total_tasks_count  = count( $tasks_overview['total_tasks']   ?? [] );
        $ready_tasks_count  = count( $tasks_overview['ready_tasks']   ?? [] );
        $percentage         = $tasks_overview['percentage']    ?? 0;
        $post_type_slugs    = $cache_data['post_type_slugs'];

        if( $total_tasks_count === $ready_tasks_count ){
            update_option( 'jptgb_consumer_status', 'paused' );
        }

        $consumer_status    = get_option( 'jptgb_consumer_status', 'paused' );
        $in_progress_class  = $consumer_status === 'active' ? ' in_progress' : '';

        ?>

        <div class="jptgb">
            <div class="jptgb jptgb-dashboard jptgb-section">
                <input id="jptgb-admin_dashboard" type="checkbox" checked>
                <div class="jptgb-section_head">
                    <label for="jptgb-admin_dashboard">Main Control</label>
                </div>
                
                <div class="jptgb-section_content jptgb-main_switchs">
                    <form class="" method="post" action="">
                        <?php Controls::render_switch_btn( 'cache_activate', 'Cache', 'Turn on/off the main cache generation.' ); ?>
    
                        <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_cache_activate', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                            <?php Controls::render_switch_btn( 'critical_css_activate', 'Css', 'Turn on/off the css optimizations.' ); ?>
                            <?php Controls::render_switch_btn( 'load_scripts_on_fui', 'Scripts', 'Turn on/off the scripts optimizations.' ); ?>
                            <?php Controls::render_switch_btn( 'images_activate', 'Images', 'Turn on/off the images optimizations.' ); ?>

                            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_load_scripts_on_fui', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                                <?php Controls::render_switch_btn( 'later_dom_load_activate', 'Later Dom Load', 'Turn on/off the Later Dom Load optimizations.' ); ?>
                            </div>
                        </div>
                        <div class="jptgb-control_message jptgb-admin_message warning">
                            Main Cache Switch is <strong>off</strong>, your site is not serving optimized pages.
                        </div>
                        <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>                        
                    </form>
                </div>
            </div>
    
            <div class="jptgb jptgb-dashboard jptgb-section">
                <input id="jptgb-admin_panel_control" type="checkbox" checked>
                <div class="jptgb-section_head">
                    <label for="jptgb-admin_panel_control">Control Panel</label>
                </div>
    
                <div class="jptgb-section_content">
                    

                    <div class="jptgb-dashboard_panel">
                        <!-- Dashboard Header -->
                        <div class="jptgb-dashboard_head">
                            <!-- Tabs Navigation for Post Types -->
                            <div class="jptgb-dashboard_cpt">
                                <?php

                                /**
                                 * Render a tab for each post type.
                                 */
                                foreach( $post_type_slugs as $post_type_slug ) {
                                    /**
                                     * Get the post type.
                                     */
                                    $post_type = get_post_type_object( $post_type_slug );

                                    /**
                                     * Continue if we can't find the post type.
                                     */
                                    if( !$post_type ){
                                        continue;
                                    }

                                    /**
                                     * Determine if this tab is active.
                                     */
                                    $active_class = ( $active_tab === $post_type_slug ) ? 'nav-tab-active' : '';

                                    /**
                                     * Render the tab link.
                                     */
                                    echo sprintf(
                                        '<a href="%s" class="jptgb-dashboard_cpt_item %s">%s</a>',
                                        esc_url( add_query_arg( 'tab', $post_type_slug, admin_url( 'admin.php?page=jptgb' ) ) ),
                                        esc_attr( $active_class ),
                                        esc_html( $post_type->labels->name )
                                    );
                                }
                                ?>

                                <a href="<?php echo esc_url( admin_url( 'admin.php?page=jptgb-settings&tab=11' ) ) ?>" class="jptgb-dashboard_cpt_item"><span class="dashicons dashicons-plus-alt2"></span></a>
                            </div>
                        </div>

                        <!-- Main Content Area -->
                        <div class="jptgb-dashboard_table_list">
                            <?php
                            /**
                             * Get the post type object.
                            */
                            $post_type_object   = get_post_type_object( $active_tab );

                            /**
                             * Check if the active tab corresponds to an existing post type.
                             */
                            if ( $post_type_object ) {
                                /**
                                 * Create and render the list table for the active tab.
                                 */
                                $list_table = new PostListTable( $active_tab );
                                $list_table->prepare_items();

                                /**
                                 * Add necessary hidden inputs for the search form.
                                 */
                                echo '<input type="hidden" name="page" value="jptgb" />';
                                echo '<input type="hidden" name="tab" value="' . esc_attr( $active_tab ) . '" />';

                                /**
                                 * Display the search box and table.
                                 */
                                echo '<form method="get">';
                                echo '<input type="hidden" name="page" value="jptgb"/>';
                                echo '<input type="hidden" name="tab" value="' .esc_attr( $active_tab ) .'"/>';
                                $search_label = sprintf(
                                    /* translators: %s: post type name (plural). */
                                    __( 'Search %s', 'webspeed' ),
                                    $post_type_object->labels->name
                                );
                                $list_table->display_search_box( $search_label );
                                echo '</form>';

                                /**
                                 * Display the table.
                                 */
                                $list_table->display();
                            } else {
                                /**
                                 * Display a message for invalid or missing tabs.
                                 */
                                echo '<p>' . esc_html__( 'Please select a valid tab.', 'webspeed' ) . '</p>';
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
    }
}