<?php

namespace Jptgb\Includes;

use Jptgb\Views\CacheSettings;
use Jptgb\Views\CriticalCssSettings;
use Jptgb\Views\GeneralSettings;
use Jptgb\Views\ScriptsSettings;
use Jptgb\Views\FontsSettings;
use Jptgb\Views\ImagesSettings;
use Jptgb\Views\LaterDomLoadSettings;
use Jptgb\Views\SelfHostedSettings;
use Jptgb\Views\LogsSettings;
use Jptgb\Views\WebsiteUrlsView;
use Jptgb\Views\PostTypesSettings;

class Settings {
    public static function render() {
        /**
         * Determine the currently active settings tab.
         *
         * Priority: POST ‘current_tab’ → GET ‘tab’ → default ‘1’.
         *
         * @var string $active_tab Sanitized tab identifier.
         */
        $active_tab = sanitize_text_field( wp_unslash( $_POST['current_tab'] ?? $_GET['tab'] ?? '1' ) );

        if ( ! empty( $_GET['tab-content'] ) ) {
            $active_tab = sanitize_text_field( wp_unslash( $_GET['tab-content'] ) );
        }

        ?>
            <div class="jptgb jptgb-section">
                <input id="jptgb-admin_settings" type="checkbox" checked>
                <div class="jptgb-section_head">
                    <label for="jptgb-admin_settings">Settings</label>
                </div>
                <div class="jptgb-section_content">
                    <div class="jptgb-admin_page">
                        <div class="jptgb-tabs">
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '1' ? 'jptgb__active' : '' ) ?>" data-tabcontent="1" role="button">Api</div>
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '2' ? 'jptgb__active' : '' ) ?>" data-tabcontent="2" role="button">Cache</div>
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '3' ? 'jptgb__active' : '' ) ?>" data-tabcontent="3" role="button">Ciritcal Css</div>
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '4' ? 'jptgb__active' : '' ) ?>" data-tabcontent="4" role="button">Scripts</div>
                            <!-- <div class="jptgb-tablink <?php // echo $active_tab == '5' ? 'jptgb__active' : ''; ?>" data-tabcontent="5" role="button">Fonts</div> -->
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '6' ? 'jptgb__active' : '' ) ?>" data-tabcontent="6" role="button">Images</div>
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '7' ? 'jptgb__active' : '' ) ?>" data-tabcontent="7" role="button">Later Dom Load</div>
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '11' ? 'jptgb__active' : '' ) ?>" data-tabcontent="11" role="button">Post Types</div>
                            <!-- <div class="jptgb-tablink <?php // echo $active_tab == '8' ? 'jptgb__active' : ''; ?>" data-tabcontent="8" role="button">Self Hosted</div> -->
                            <div class="jptgb-tablink <?php echo esc_attr( $active_tab == '9' ? 'jptgb__active' : '' ) ?>" data-tabcontent="9" role="button">Debug</div>
                        </div>

                        <form class="jptgb-tabcontent_wrap" method="post" action="">
                            <div id="jptgb-tabcontent_1" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '1' ? 'jptgb__active' : '' ) ?>"">
                                <?php GeneralSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_2" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '2' ? 'jptgb__active' : '' ) ?>"">
                                <?php CacheSettings::render() ?>
                            </div>
                    
                            <div id="jptgb-tabcontent_3" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '3' ? 'jptgb__active' : '' ) ?>">
                                <?php CriticalCssSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_4" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '4' ? 'jptgb__active' : '' ) ?>">
                                <?php ScriptsSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_5" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '5' ? 'jptgb__active' : '' ) ?>">
                                <?php // echo FontsSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_6" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '6' ? 'jptgb__active' : '' ) ?>">
                                <?php ImagesSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_7" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '7' ? 'jptgb__active' : '' ) ?>">
                                <?php LaterDomLoadSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_8" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '8' ? 'jptgb__active' : '' ) ?>">
                                <?php // SelfHostedSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_9" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '9' ? 'jptgb__active' : '' ) ?>">
                                <?php LogsSettings::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_10" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '10' ? 'jptgb__active' : '' ) ?>">
                                <?php WebsiteUrlsView::render() ?>
                            </div>

                            <div id="jptgb-tabcontent_11" class="jptgb-tabcontent <?php echo esc_attr( $active_tab == '11' ? 'jptgb__active' : '' ) ?>">
                                <?php PostTypesSettings::render() ?>
                            </div>

                            <input type="hidden" name="current_tab" id="jptgb-current_tab" value="<?php echo esc_attr( $active_tab ) ?>">
                        </form>

                        <div class="jptgb-not">
                            <svg xmlns="http://www.w3.org/2000/svg" height="16" width="16" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"/></svg>
                            <div class="jptgb-not_message">
                                <div class="jptgb-not_title"></div>
                                <div class="jptgb-not_description"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
    }
}
