<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;
use Jptgb\Resources\Utils;

class CacheSettings extends BaseController {
    public static function render() {

        $checkboxes_data = Utils::get_post_type_labels_and_names_excluding_attachments();

        ?>
        <div class="jptgb-setting_title">Cache</div>
        <div class="jptgb-setting_description">Handles the cache of the site.</div>

        <div class="jptgb-tabcontent_content">
            <?php Controls::render_switch_btn( 'cache_activate', 'Activate', 'Turn the cache on/off' ); ?>

            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_cache_activate', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                <?php // Controls::render_switch_btn( 'set_expire_headers', 'Set Expire Headers', 'Set expire headers for the entire site' ); ?>
                <?php Controls::render_switch_btn( 'mobile_cache', 'Mobile Cache', 'Create a separated cache for mobile devices only' ); ?>
                <?php Controls::render_switch_btn( 'bypass_cache_layers', 'Bypass External Caching Layers', 'When enabled, the API will append a unique “bypasscache” query parameter (e.g., ?bypasscache=12345) to each URL, forcing all caching layers to be skipped.' ); ?>
                <?php Controls::render_switch_btn( 'show_columntool_on_posts', 'Show Column Tool On Posts', 'Show Column Tool On Posts, Pages and any othe Custom Post Types with UI.' ); ?>

                

                <?php Controls::render_switch_btn( 'allow_params', 'Allow Parameters', 'Create cache pages also for url with parameters.' ); ?>
                <?php Controls::render_input_field( 'cache_expiration_time', 'number', 'Cache Expiration Time', 'Define the number hours a cache file should exist. After the cache files expires a new cache file will be generated automatically. Default value is set to 240hrs (10 days).', [], '', '', [ 'min' => 1, 'step' => 1 ] ); ?>
                <?php // Controls::render_switch_btn( 'flush_cache_on_posts_publish', 'Flush All Cache On Post Publish', 'When a new post gets published, then we reset all static cache files.' ); ?>
                <?php Controls::render_checkbox_group( 'flush_cache_on_post_types_publish', 'Post Types That Flush Cache On Publish', 'Define what posts types should trigger the Flush Cache when they get published', $checkboxes_data, [ [ 'id' => 'jptgb_setting_flush_cache_on_posts_publish', 'operator' => '==', 'value' => true ] ] ) ?>
                <?php Controls::render_input_field( 'exclude_ids_for_cache', 'text', 'Posts IDs to Exclude', 'Enter coma-separed posts ids on which you don\'t want the cache to work.'); ?>
                <?php Controls::render_button( 'flush_all_cache', 'Flush all cache', 'Flush all cache files of the site', 'Flush Cache Now', 'danger' ); ?>

                <?php // Advanced options ?>
                <?php Controls::render_switch_btn( 'cache_advanced_options', 'Display Advanced Options', 'Display/hide the advanced options' ); ?>
                <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_cache_advanced_options', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                    <?php Controls::render_switch_btn( 'use_custom_htaccess_path', 'Set Custom Htaccess Path', 'Set a custom path for the htaccess file' ); ?>
                    <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_use_custom_htaccess_path', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                        <?php Controls::render_input_field( 'custom_htaccess_path', 'text', 'Custom Htaccess Path', 'Define the absolute path to the htaccess file'); ?>
                    </div>
                </div>
            </div>

            <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        </div>
        <?php
    }
}
