<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;

class CriticalCssSettings extends BaseController {
    public static function render() {
        ?>
        <div class="jptgb-setting_title">Critical Css</div>
        <div class="jptgb-setting_description">Handles the critical css.</div>

        <div class="jptgb-tabcontent_content">
            <?php Controls::render_switch_btn( 'critical_css_activate', 'Activate', 'Turn on/off the Critical Css' ); ?>

            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_critical_css_activate', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                <?php Controls::render_input_field( 'custom_css_in_critical', 'textarea', 'Custom Css to insert in the Critical Css', 'Add custom css to be inserted in the Critical Css tag. <br>Note: All the below the content wrapping elements will have the class "jptgb_btf_content", when the css of the page gets loaded, then the class will be removed from the elements', [], '', '.jptgb_btf_content{color: red;}' ); ?>
                <?php Controls::render_input_field( 'exclude_styles', 'textarea', 'Styles Selectors to Exclude Load On FUI', 'Enter coma-separed ids and/or class names of style tags that you don\'t want to load it after FUI. This styles will be loaded as soon as the cache page get served.'); ?>
                <?php // Controls::render_input_field( 'include_in_critical_css', 'textarea', 'IDs or Class Names of Stylesheets to Include in the Critical Css', 'Enter coma-separed ids and/or class names of stylesheets which css properties you want to include manually the the critical css generation.'); ?>
                <?php // Controls::render_input_field( 'include_rulesets_in_critical', 'textarea', 'Include in the Critical Css, rulesets that contain the following', 'Enter in each line the exact sentence that a given rulset must contina in order to include the entire ruleset into the critical css.'); ?>
                <?php Controls::render_switch_btn( 'load_fonts_on_fui', 'Load Fonts On Fui', 'Load fonts only after First User Interaction (FUI).' ); ?>
                <?php Controls::render_switch_btn( 'load_fa_icons_on_fui', 'Load Fonts Awesome Icons On Fui', 'Load Font Awesome Icons only after First User Interaction (FUI).' ); ?>
                <?php Controls::render_button( 'flush_all_crtical_css', 'Flush critical css', 'Regenerates all the critical css of the pages, however it will not call the ciritical css API if the requested css to generate is identical to the ones previously saved.', 'Flush Critical Css Now', 'danger' ); ?>
            </div>

            <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        </div>
        <?php
    }
}
