<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;

class FontsSettings extends BaseController {
    public static function render() {
        ?>
        <div class="jptgb-setting_title">Fonts</div>
        <div class="jptgb-setting_description">Handles the fonts of the site.</div>

        <div class="jptgb-tabcontent_content">
            <?php Controls::render_switch_btn( 'fonts_activate', 'Activate', 'Turn on/off the Fonts Optimizations.' ); ?>

            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_fonts_activate', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                <?php Controls::render_switch_btn( 'load_fonts_on_fui', 'Load Fonts On Fui', 'Load fonts only after First User Interaction (FUI).' ); ?>
                <?php Controls::render_switch_btn( 'load_fa_icons_on_fui', 'Load Fonts Awesome Icons On Fui', 'Load Font Awesome Icons only after First User Interaction (FUI).' ); ?>
            </div>

            <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        </div>
        <?php
    }
}
