<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;

class GeneralSettings extends BaseController {
    public static function render() {
        $number_of_urls         = self::get_setting('number_of_urls');
        $registered_urls        = self::get_setting('registered_urls');
        $api_plan_name          = self::get_setting('jptgb_setting_api_plan');
        $expiration_date        = self::get_setting('jptgb_setting_expiration_date');
        $expiration_status      = self::get_setting('jptgb_setting_api_plan_status');
        $url_rate               = self::get_setting('url_rate');

        $subs_status        = self::get_setting('jptgb_setting_subscription_status');
        $subs_status_label  = $subs_status ? 'Active' : 'Inactive';
        $subs_status_class  = $subs_status ? 'active' : 'inactive';
        $api_plan_name      = $api_plan_name ?: '-';
        $url_rate           = (string) $registered_urls . '/' . (string) $number_of_urls;
        $url_rate_class     = ( $registered_urls > $number_of_urls ) ? 'inactive' : '';

        if( $expiration_date and strtotime( $expiration_date ) !== false ){
            /**
             * Create a DateTime object from the given string
             */
            $date = new \DateTime($expiration_date);
    
            /**
             * Format the date to display only year, month, and day
             */
            $expiration_date = $date->format('Y-m-d');
        } else {
            $expiration_date = '-';
        }

        /**
         * Define the api key status.
         */
        $api_key_status = self::$settings['jptgb_setting_is_api_key_valid'] ?: 'error';

        ?>
        <div class="jptgb-setting_title">General</div>
        <div class="jptgb-setting_description">General settings of the plugin.</div>

        <div class="jptgb-tabcontent_content">
            <?php 
                Controls::render_info( 'Subscription Status', 'The status of your subscription', $subs_status_label, $subs_status_class );
                Controls::render_info( 'Plan Name', 'The name of the current plan', $api_plan_name );
                Controls::render_info( 'URLs Rate', 'The rate between the number of urls for which we have genererated a cache page and the max number allowed.', $url_rate, $url_rate_class );
                Controls::render_info( 'Expiration Date', 'The date on which the current plant will expire.', $expiration_date, $expiration_status );
                Controls::render_button( 'sync_with_api', 'Sync with API', 'Sync current data with the API', 'Api Sync', 'info' );
                //Controls::render_input_field( 'api_endpoint', 'text', 'API Endpoint', 'Define the endpoint of the API.', [ 'id' => 'test_api_endpoint', 'label' => 'Test API Endpoint' ] );
                //Controls::render_input_field( 'user_email', 'email', 'User Email', 'Submit your email in order to get the API key.' );
                Controls::render_input_field( 'api_key', 'text', 'Api Key', 'Set your api key.<br><a href="https://webspeed.ai/blog/how-to-retrieve-and-set-your-webspeed-ai-api-key/" target="_blank">How Do I get my API Key?</a>', [], $api_key_status );
                //Controls::render_input_field( 'allowed_domain', 'text', 'Allowed Domain', 'Enter the allowed domain to call the API.', [], '', 'e.g. mydomain.com');
                //Controls::render_button( 'delete_user', 'Delete Account', 'Delete the user data from the API service', 'Delete Account', 'danger' );

                Controls::render_switch_btn( 'delete_all_plugins_data_swtich', 'Show Delete Data Option', 'This switch show up the option to delete all the data stored in the DB and related with this plugin' ); ?>

                <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_delete_all_plugins_data_swtich', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                    <?php Controls::render_button( 'delete_plugins_data', 'Delete all Plugin\'s Data', 'Remove all the data related to the plugin from the Database, including configuration, api key, etc.', 'Delete Plugin\'s Data', 'danger' ); ?>
                </div>
            <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        </div>
        <?php
    }
}
