<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;

class ImagesSettings extends BaseController {
    public static function render() {
        ?>
        <div class="jptgb-setting_title">Images</div>
        <div class="jptgb-setting_description">Handles the images of the cache pages of the site.</div>

        <div class="jptgb-tabcontent_content">
            <?php Controls::render_switch_btn( 'images_activate', 'Activate', 'Turn on/off the Images Optimizations.' ); ?>

            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_images_activate', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                <?php Controls::render_switch_btn( 'resize_images', 'Resize Images', 'Resize all images of the cached pages to improve the performance.' ); ?>
                <?php Controls::render_switch_btn( 'compress_svg', 'Compress Svg', 'Compress all svgs of the cached pages.' ); ?>
                <?php Controls::render_switch_btn( 'convert_images_to_webp', 'Convert Images to Webp', 'Convert all images of the cached pages to webp.' ); ?>
                <?php Controls::render_input_field( 'webp_quality_rate', 'number', 'Web Quality Rate', 'Range from 0 to 100, the higher the number means less compression and more quality.' ); ?>
                <?php Controls::render_input_field( 'mpa_webp_quality_rate', 'number', 'Largest Image Paint Web Quality Rate', 'Define the compression quality for the largest Image paint area of the above the fold elements. Range from 0 to 100, the higher the number means less compression and more quality.' ); ?>
                <?php Controls::render_switch_btn( 'set_explicit_w_and_h', 'Set Explicit Width and Height', 'Automatically set explicit width and height to all images of the cached pages.' ); ?>
                <?php Controls::render_switch_btn( 'optimize_only_atf_images', 'Optimize Only Above-The-Fold images', 'It optimize only the above the fold images' ); ?>

                <?php Controls::render_button( 'flush_all_images', 'Delete All Compressed Images', 'Delete all optimized images saved by the plugin in local storage.<br>Note: This images were generated by this plugin and they are being used only by this plugin, so this action will not affect any images in the Media Library.', 'Delete Compressed Images Now', 'danger' ); ?>
            </div>

            <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        </div>
        <?php
    }
}
