<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;

class LaterDomLoadSettings extends BaseController {
    public static function render() {
        ?>
        <div class="jptgb-setting_title">Later Dom Load</div>
        <div class="jptgb-setting_description"></div>

        <div class="jptgb-tabcontent_content">
            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_load_scripts_on_fui', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                <?php Controls::render_switch_btn( 'later_dom_load_activate', 'Activate', 'Turn on/off the Later Dom Load Optimizations.' ); ?>

                <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_later_dom_load_activate', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                    <?php Controls::render_switch_btn( 'lazy_dom_load', 'Lazy Dom Load (LDL)', 'Lazy Dom Load, modify the cache files so it does wrapp the below-the-fold content in empty placeholders, the function makes an AJAX call back to the server to bring the remaining content right after the First User Iteraction.' ); ?>
                    <?php Controls::render_switch_btn( 'immediate_dom_load', 'Immediate Dom Load (IDL)', 'Immediate Dom Load, modify the cache files so it does wrapp the below-the-fold content in html comments, the content gets ucommented right after First User Iteraction.' ); ?>
                    <?php Controls::render_switch_btn( 'idl_for_hidden_elements', 'Apply IDL to Hidden Elements', 'This option improves the LDL since it applies also to elements above-the-fold which are "hidden", however it might inpact layout shift after FUI.' ); ?>
                    <?php Controls::render_input_field( 'exclude_ids_for_ldl', 'text', 'Posts IDs to Exclude', 'Enter coma-separed posts ids on which you don\'t want the Later Dom Load to apply.'); ?>
                </div>

                <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
            </div>
            <div class="jptgb-control_message jptgb-admin_message warning">
                This features requires <strong>Load Scripts On Fui</strong> option to be activated.
            </div>
        </div>
        <?php
    }
}
