<?php

namespace Jptgb\Views;

use Jptgb\Controllers\BaseController;
use Jptgb\Includes\Controls;
use Jptgb\Resources\Utils;

class LogsSettings extends BaseController {
    public static function render() {
        ?>
        <div class="jptgb-setting_title">Debug</div>
        <div class="jptgb-setting_description">Only for debugging purposes.</div>

        <?php Controls::render_switch_btn( 'debug_activate', 'Activate Debug', 'Turn the debugging on/off. <br><b>Important:</b> The Debug will turn off automatically after 1hr.' ); ?>
        <?php Controls::render_switch_btn( 'activate_logs', 'Activate Logs', 'Register logs in the database of the site.' ); ?>

        <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>

        <hr>

        <?php Controls::render_button( 'delete_all_logs', 'Delete All Logs', 'Remove all logs records from the database.', 'Delete All Logs Now', 'danger', 'submit' ); ?>

        <div class="jptgb-tabcontent_content jptgb-logs_wrapper">
            <?php
            // 1) Determine current page from URL (?paged=2). Default to 1 if missing/invalid.
            $paged = isset( $_GET['paged'] ) ? intval( $_GET['paged'] ) : 1;
            if ( $paged < 1 ) {
                $paged = 1;
            }

            // 2) How many logs to display per page.
            $per_page = 50;

            // 3) Get total number of logs so we can calculate total pages.
            $total_logs  = BaseController::$logs->get_total_log_count();
            $total_pages = (int) ceil( $total_logs / $per_page );

            // 4) Fetch only the logs for the current page.
            $current_logs = BaseController::$logs->get_logs_page( $paged, $per_page );

            // 5) Output each log entry.
            if ( ! empty( $current_logs ) ) {
                foreach ( $current_logs as $log ) {
                    // Always escape output in WordPress
                    $created_at = esc_html( $log->created_at );
                    $type       = esc_html( strtoupper( $log->type ) );
                    $message    = esc_html( $log->message );
                    $output     = $created_at . '[' . $type . ']' . ' - ' . $message;
                    ?>
                        <p><?php echo esc_html( $output  ) ?></p>
                    <?php
                }
            } else {
                ?>
                    <p>No logs found.</p>
                <?php
            }
            ?>
        </div>

        <?php
        // 6) Render pagination links if there’s more than one page.
        if ( $total_pages > 1 ) {
            /**
             * Build a “base” URL that always points to your settings page,
             * then append &paged=%#% so paginate_links() can swap %#% with each page number.
             *
             * admin_url( 'admin.php?page=jptgb-settings' ) returns something like:
             *    https://webspeed.loc/wp/wp-admin/admin.php?page=jptgb-settings
             *
             * Appending '&paged=%#%' yields:
             *    https://webspeed.loc/wp/wp-admin/admin.php?page=jptgb-settings&paged=%#%
             */
            $base_url = esc_url( admin_url( 'admin.php?page=jptgb-settings&tab-content=9&paged=%#%' ) );

            ?>
            <div class="jptgb-pagination" style="margin-top: 5px; font-size: 14px;">
                <?php
                echo wp_kses_post( 
                    paginate_links( [
                        'base'      => $base_url,    // <-- **Do not** wrap this in esc_url().
                        'format'    => '',           
                        'current'   => $paged,
                        'total'     => $total_pages,
                        'prev_text' => '‹ Prev',
                        'next_text' => 'Next ›',
                    ] )
                );
                ?>
            </div>
            <?php
        }
        ?>
            <h2>System Info</h2>
            <div class="jptgb-system_info">
                <div class="jptgb-system_detail"><b>Wp Site Url: </b><span><?php echo esc_url( Utils::get_site_url() ); ?></span></div>
                <div class="jptgb-system_detail"><b>Wp Site Domain: </b><span><?php echo esc_attr( Utils::get_site_doamin() ); ?></span></div>
                <div class="jptgb-system_detail"><b>Wp Root Directory: </b><span><?php echo esc_url( Utils::get_true_wp_root_directory() ); ?></span></div>
                <div class="jptgb-system_detail"><b>Cache Expiration Time: </b><span><?php echo esc_attr( (int) self::get_setting( 'cache_expiration_time' ) ); ?></span></div>
            </div>
        <?php
    }
}
