<?php

namespace Jptgb\Views\Partials;

class AdminHeader {
    /**
     * Render the dashboard page.
     */
    public static function render() {
        ?>
        <div class="wrap">
            <h1 style=""><?php echo __( 'WebSpeed Optimizations', 'webspeed' ); ?></h1>

            <div class="jptgb-main_nav">
                <?php
                // Define navigation links with labels and their corresponding 'page' values
                $navigation_links = [
                    'Dashboard' => 'jptgb',
                    'Settings'  => 'jptgb-settings',
                ];

                // Get the current 'page' parameter
                $current_page = isset( $_GET['page'] ) ? $_GET['page'] : '';

                // Generate navigation links
                foreach ( $navigation_links as $label => $page ) {
                    // Determine if this link is active
                    $is_active = ( $current_page === $page );
                    $active_class = $is_active ? 'active' : '';

                    // Build the link URL
                    $url = esc_url( admin_url( 'admin.php?page=' . $page ) );

                    // Output the link
                    echo sprintf(
                        '<a href="%s" class="%s">%s</a>',
                        esc_url( $url ),
                        esc_attr( $active_class ),
                        esc_html( $label )
                    );
                }
                ?>
            </div>
        <?php
    }
}
