<?php

namespace Jptgb\Views;

use Jptgb\Includes\Controls;
use Jptgb\Controllers\BaseController;

class ScriptsSettings extends BaseController {
    public static function render() {
        ?>
        <div class="jptgb-setting_title">Scripts</div>
        <div class="jptgb-setting_description">All scripts are goning to be deactivated during the creation of the static html file, they will run only after FUI when a static file gets served.</div>

        <div class="jptgb-tabcontent_content">
            <?php Controls::render_switch_btn( 'load_scripts_on_fui', 'Load Scripts On Fui', 'Load scripts only after First User Interaction (FUI).' ); ?>

            <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_load_scripts_on_fui', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                <?php Controls::render_switch_btn( 'load_iframes_on_fui', 'Load iFrames On Fui', 'Load iframes only after First User Interaction (FUI).' ); ?>
                <div class="jptgb-control_group" data-displayconditions="<?php echo esc_attr( json_encode( [ [ 'id' => 'jptgb_setting_load_iframes_on_fui', 'operator' => '==', 'value' => true ] ] ) ) ?>">
                    <?php Controls::render_switch_btn( 'generate_iframes_bg', 'Generate Background Image for iFrames', 'Automatically generates an image based on the iframe rendering and set it as the background. This feature will not apply if the iframe has already a background image defined.' ); ?>
                </div>

                <?php Controls::render_input_field( 'exclude_scripts', 'textarea', 'Scripts Selectors to Exclude Load On FUI', 'Enter coma-separed ids and/or class names of scripts that you don\'t want to load it after FUI. This scripts will be excluded in the generation on the cache page, however they will be executed as soon as the cache page get served.'); ?>
                <?php Controls::render_input_field( 'exclude_deactivation_scripts', 'textarea', 'Scripts Selectors to Allow On Cache Creation Execution', 'Enter coma-separed scripts selectors that you want to execute during the creation of the Cache. These scripts going to be executed only once during the cache creation so they will not execute when the browsers requests the static html page.'); ?>
                <?php // Controls::render_switch_btn( 'modify_external_scripts', 'Modify External Scripts', 'Modify external scritps in order to place our custom events triggers' ); ?>
                <?php // Controls::render_input_field( 'exclude_external_scripts_from_modify', 'textarea', 'Specific Scripts To Not Modify', 'Enter coma-separed scripts objects to exclude from modification. The logic if gonna check if the scripts contain the attribute values specified, if more than an attribute is set, then it will exclude if all conditions meet.', [], '', "e.g. {id: 'script_id'},\n{class: 'script_class'},\n{id: 'stripe_id', src: 'stripe'}"); ?>

            </div>

            <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        </div>
        <?php
    }
}
