<?php

namespace Jptgb\Views;

use Jptgb\Controllers\BaseController;
use Jptgb\Controllers\SelfHostedController;
use Jptgb\Includes\Controls;
use Jptgb\Resources\Utils;

class SelfHostedSettings extends BaseController {
    public static function render() {

        /**
         * Get the status of all the services.
         */
        $services_statuses = SelfHostedController::get_services_status();  

        ?>
        <div class="jptgb-setting_title">Self Hosted Application</div>
        <div class="jptgb-setting_description">Self hosted applications.</div>

        <?php Controls::render_switch_btn( 'activate_self_hosted', 'Activate Self Hosted', 'Do perform the optimizations using self hosted code.' ); ?>
        <?php Controls::render_input_field( 'path_puppetter_chromium', 'text', 'Chromium Path for Puppetter', 'Define the path that puppetter should use to load chromium, if left blank then Puppetter will use the default location.'); ?>
        <?php Controls::render_input_field( 'path_penthouse_chromium', 'text', 'Chromium Path for Penthouse', 'Define the path that Penthouse should use to load chromium, if left blank then Penthouse will use the default location.'); ?>

        <div class="jptgb-hosted">

            <?php
                foreach( $services_statuses as $service_status ) : ?>
                    <?php 
                        $status     = $service_status['status'] ?? 'inactive';
                        $name       = $service_status['name'] ?? '';
                        $message    = $service_status['output_msg'] ?? '';
                    ?>
                    <div class="jptgb-service <?php echo esc_attr( $status ) ?>">
                        <div class="jptgb-service_status"><?php echo esc_html( $message ) ?></div>
                        <input class="" type="submit" name="install_<?php echo esc_attr( $name ) ?>" value="Install <?php echo esc_html( $name ) ?>">
                    </div>
                <?php endforeach; ?>
        </div>
        
        <button class="jptgb-btn_update button button-primary button-large" type="submit" name="jptgb_update" value="update_settings">Save Settings</button>
        <?php

    }
}
