/**
 * Handles the Admin BAr App.
 *
 * @package Jptgb
 * */

class JptgbAdminBar {
	constructor() {
        if (document.readyState != "loading") {
            this.init();
        }
        else {
            document.addEventListener("DOMContentLoaded", () => {
                this.init();
            });
        }
	}

    init() {
        /**
         * Get the message.
         */
        const message = jptgbCacheData.cacheClearedMessage;

        if (message) {
            var popup = document.createElement('div');
            popup.id = 'jptgbCacheClearedPopup';
            popup.innerHTML = `<div><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><!--!Font Awesome Free 6.5.1 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license/free Copyright 2024 Fonticons, Inc.--><path d="M256 48a208 208 0 1 1 0 416 208 208 0 1 1 0-416zm0 464A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 209z"/></svg></div><span>${message}</span>`;
            
            document.body.appendChild(popup);
    
            
            /**
             * Wait for 0.5 seconds, then show the message.
             */
            setTimeout(function() {
                /**
                 * Slide down.
                 */
                popup.classList.add('visible');

                /**
                 * Wait for 2 seconds, then slide up and remove the popup.
                 */
                setTimeout(function() {
                    popup.classList.remove('visible');
                    setTimeout(function() {
                        document.body.removeChild(popup);
                    }, 300); // Assuming the slide-up transition is 300ms
                }, 3000);
            }, 1000);
        }
    }
}

new JptgbAdminBar();