let mix = require('laravel-mix');
const CopyPlugin = require('copy-webpack-plugin');

    /**
     * Setting Public Path to Project's
     */
    mix.setPublicPath("./")

    /**
     * Custom Babel configuration to target modern browsers and exclude older ones like IE 11.
     */
    mix.babelConfig({
        presets: [
        ['@babel/preset-env', {
            targets: '> 0.25%, not dead, not ie 11'
        }]
        ]
    });

    /**
     * Controllers scripts.
     */
    mix.js('src/js/controllers/in-cache.js', 'assets/js/controllers/in-cache.js')
    mix.js('src/js/controllers/helper.js', 'assets/js/controllers/helper.js')

    /**
     * Admin assets.
     */
    mix.js('src/js/adminbar.js', 'assets/js/jptgb-adminbar.js')
    mix.js('src/js/admin.js', 'assets/js/jptgb-admin.js')
    .sass('src/sass/adminbar.scss', 'assets/css/jptgb-adminbar.css')
    .sass('src/sass/admin.scss', 'assets/css/jptgb-admin.css')
    .version()
    .webpackConfig({
        plugins: [
            new CopyPlugin({
                patterns: [
                    { from: '/Users/yaidier/workspace/docker-sites/webspeed-api/includes', to: 'src/js/self-hosted/includes' },
                    { from: '/Users/yaidier/workspace/docker-sites/webspeed-api/assets', to: 'src/js/self-hosted/assets' },
                ]
            })
        ]
    });
