<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://yaidier.com
 * @since             1.1
 * @package           WebSpeed_AI
 *
 * @wordpress-plugin
 * Plugin Name:       WebSpeed
 * Plugin URI:        https://yaidier.com
 * Description:       Skyrocket your WordPress site's performance.
 * Version:           1.8.52
 * Author:            Yaidier Perez
 * Author URI:        https://yaidier.com
 * License:           GPLv2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       webspeed
 */

/**
 * If this file is called directly, abort.
 */
if ( !defined( 'WPINC' ) ) {
	die;
}

// In WP < 5.5, this might not be loaded yet:
if ( ! function_exists( 'is_plugin_active' ) ) {
    require_once ABSPATH . 'wp-admin/includes/plugin.php';
}

$plugin_basename = plugin_basename( __FILE__ );

/**
 * 2) Always register this: show an admin notice if we just redirected.
 */
add_action( 'admin_notices', function() {
    if ( ! empty( $_GET['ws_free_pro_error'] ) ) {
        ?>
        <div class="notice notice-error is-dismissible">
            <p>
                <?php
                /* translators: 1: Free, 2: Pro */
                echo sprintf(
                    'Cannot activate %1$s because %2$s is active. Please deactivate the <b>Pro</b> version first.',
                    '<strong>WebSpeed</strong>',
                    '<strong>WebSpeed Pro</strong>'
                );
                ?>
            </p>
        </div>
        <?php
    }
} );

// If Pro is active, bail *before* loading any of our code:
if( 'webspeed-pro/webspeed.php' !== $plugin_basename ){
    register_activation_hook( __FILE__, function() {
        if ( \is_plugin_active( 'webspeed-pro/webspeed-pro.php' ) ) {
            wp_die(
                /* translators: 1=Free, 2=Pro */
                sprintf(
                    'Cannot activate %1$s because %2$s is active. Please deactivate the Pro version first.',
                    '<strong>WebSpeed</strong>',
                    '<strong>WebSpeed Pro</strong>'
                ),
                'Activation Error',
                [ 'back_link' => true ]
            );
        }
    } );

    if ( \is_plugin_active( 'webspeed-pro/webspeed.php' ) ) {
        deactivate_plugins( plugin_basename( __FILE__ ) );
        add_action( 'admin_notices', function() {
            ?>
            <div class="notice notice-error">
                <p>
                    <?php
                    /* translators: 1: Free, 2: Pro */
                    echo sprintf(
                        'Cannot load %1$s because %2$s is active. Please deactivate the Pro version first.',
                        '<strong>WebSpeed</strong>',
                        '<strong>WebSpeed Pro</strong>'
                    );
                    ?>
                </p>
            </div>
            <?php
        } );

        $redirect = add_query_arg(
            'ws_free_pro_error',
            '1',
            esc_url( admin_url( 'plugins.php' ) )
        );

        wp_redirect( $redirect );
        exit;
        return;
    } else {
        require __DIR__ . '/main.php';
    }
}


